<!DOCTYPE html>
<html>
<head>
    <title>How to Integrate Razorpay payment gateway in PHP | Musecomm.net</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet" media="screen">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <script type="text/javascript" src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>

</head>

<body style="background-repeat: no-repeat;">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title">Charge Rs.10 INR </h4>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control" name="billing_name" id="billing_name"
                                placeholder="Enter name" required="" autofocus="">
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" class="form-control" name="billing_email" id="billing_email"
                                placeholder="Enter email" required="">
                        </div>

                        <div class="form-group">
                            <label>Mobile Number</label>
                            <input type="number" class="form-control" name="billing_mobile" id="billing_mobile"
                                min-length="10" max-length="10" placeholder="Enter Mobile Number" required=""
                                autofocus="">
                        </div>

                        <div class="form-group">
                            <label>Payment Amount</label>
                            <input type="text" class="form-control" name="payAmount" id="payAmount" value="10"
                                placeholder="Enter Amount" required="" autofocus="">
                        </div>

                        <!-- submit button -->
                        <button id="PayNow" class="btn btn-success btn-lg btn-block">Submit & Pay</button>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    //Pay Amount
    jQuery(document).ready(function($) {

        jQuery('#PayNow').click(function(e) {
            e.preventDefault(); 
            var paymentOption = '';
            let billing_name = $('#billing_name').val();
            let billing_mobile = $('#billing_mobile').val();
            let billing_email = $('#billing_email').val();
            // var shipping_name = $('#billing_name').val();
            // var shipping_mobile = $('#billing_mobile').val();
            // var shipping_email = $('#billing_email').val();
            var paymentOption = "netbanking";
            var payAmount = $('#payAmount').val();

            var request_url = "submitpayment.php";
            var formData = {
                billing_name: billing_name,
                billing_mobile: billing_mobile,
                billing_email: billing_email,
                // shipping_name: shipping_name,
                // shipping_mobile: shipping_mobile,
                // shipping_email: shipping_email,
                paymentOption: paymentOption,
                payAmount: payAmount,
                action: 'payOrder'
            }

            $.ajax({
                type: 'POST',
                url: request_url,
                data: formData,
                dataType: 'json',
                encode: true,
            }).done(function(data) {

                if (data.res == 'success') {
                    var orderID = data.order_number;
                    var orderNumber = data.order_number;
                    var options = {
                        "key": data.razorpay_key, // Enter the Key ID generated from the Dashboard
                        "amount": data.userData.amount, // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
                        "currency": "INR",
                        "name": "Musecomm", //your business name
                        "description": data.userData.description,
                        "image": "https://musecomm.net/images/muse-logo.svg",
                        "order_id": data.userData.rpay_order_id, //This is a sample Order ID. Pass 
                        "handler": function(response) {
                            alert("paymenent success response"+response);
                            alert("Payment Success!\n" + 
          "Razorpay Payment ID: " + response.razorpay_payment_id + "\n" + 
          "Razorpay Order ID: " + response.razorpay_order_id + "\n" + 
          "Signature: " + response.razorpay_signature);

    // 🚀 Debugging: Do NOT redirect immediately, check console output
    console.log("Redirecting to Success Page...");
    let successUrl = "payment-success.php?oid=" + orderID + 
                     "&rp_payment_id=" + encodeURIComponent(response.razorpay_payment_id) + 
                     "&rp_signature=" + encodeURIComponent(response.razorpay_signature)+
                     "&razorpay_order_id=" + encodeURIComponent(response.razorpay_order_id);
                     window.location.replace(successUrl);
                            // window.location.replace("payment-success.php?oid=" +
                            //     orderID + "&rp_payment_id=" + response.razorpay_payment_id + "&rp_signature=" + response.razorpay_signature);

                        },
                        "modal": {
                            "ondismiss": function() {
                                console.log("🛑 Payment Modal Closed!");
                                // window.location.replace("payment-success.php?oid=" +
                                //     orderID);
                            }
                        },
                        "prefill": { //We recommend using the prefill parameter to auto-fill customer's contact information especially their phone number
                            "name": data.userData.name, //your customer's name
                            "email": data.userData.email,
                            "contact": data.userData.mobile //Provide the customer's phone number for better conversion rates 
                        },
                        "notes": {
                            "address": "Musecommwebsite"
                        },
                        "config": {
                            "display": {
                                "blocks": {
                                    "banks": {
                                        "name": 'Pay using ' + paymentOption,
                                        "instruments": [

                                            {
                                                "method": paymentOption
                                            },
                                        ],
                                    },
                                },
                                "sequence": ['block.banks'],
                                "preferences": {
                                    "show_default_blocks": true,
                                },
                            },
                        },
                        "theme": {
                            "color": "#3399cc"
                        }
                    };
                    var rzp1 = new Razorpay(options);
                    // console.log("Razorpay instance created:", rzp1);
                    rzp1.on('payment.failed', function(response) {
                        // console.log("Payment Failed Event Triggered");
                        console.log("Error Details:", response.error);
                        alert("Payment Failed!\n" +
                        "Reason: " + response.error.description + "\n" +
                        "Payment ID: " + response.error.metadata.payment_id);
                        let orderID = orderID; // Ensure this is defined
                        let description = encodeURIComponent(response.error.description || "Unknown description");
                        let reason = encodeURIComponent(response.error.description || "Unknown reason");
                        let source = encodeURIComponent(response.error.source || "Unknown source");
                        let step = encodeURIComponent(response.error.step || "Unknown step");
                        let code = encodeURIComponent(response.error.code || "Unknown code");
                        let rp_payment_id = encodeURIComponent(response.error.metadata?.payment_id || "N/A");
                        let rp_order_id = encodeURIComponent(response.error.metadata?.order_id || "N/A");
                        let redirectUrl = "payment-failed.php?oid=" + orderID + 
                            "&reason=" + encodeURIComponent(reason) + 
                            "&source=" + encodeURIComponent(source)+
                            "&description=" + encodeURIComponent(description)+
                            "&code=" + encodeURIComponent(code)+
                            "&code=" + encodeURIComponent(code)+
                            "&rp_payment_id=" + encodeURIComponent(crp_payment_idode)+
                            "&rp_order_id=" + encodeURIComponent(rp_order_id);
                            // console.log("Redirecting to:", redirectUrl);
                            window.location.replace(redirectUrl);
                        });
                    rzp1.open();
                    e.preventDefault();
                }

            });
        });
    });
    </script>

</body>

</html>