<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'db_connection.php';  // Ensure this file correctly initializes $conn
// echo "hi";die;
if(isset($_GET)){
    $order_id = isset($_GET['oid']) ? $_GET['oid'] : 'Missing OID';
    // $payment_id = isset($_GET['payment_id']) ? $_GET['payment_id'] : 'Missing Payment ID';
    $status = 'failed';
    $reason = isset($_GET['reason']) ? $_GET['reason'] : 'Missing reason';
    $source = isset($_GET['source']) ? $_GET['source'] : 'Missing Source';
    $step = isset($_GET['step']) ? $_GET['step'] : 'Missing Step';
    $description = $_GET['description'];
    $code = $_GET['code'];
    $rp_payment_id = $_GET['rp_payment_id'];
    $rp_order_id = $_GET['rp_order_id'];
    
    // Pass $conn to the function
    update_order_payment_status($conn, $order_id, $status, $source, $step, $reason, $description,$code,$rp_payment_id,$rp_order_id);
}

function update_order_payment_status($conn, $order_id, $status, $source, $step, $reason, $description,$code,$rp_payment_id,$rp_order_id) {
    try {
        // Prepare statement
        $stmt = $conn->prepare("UPDATE orders SET payment_status = ?, source = ?, step = ?, reason = ?, description = ?, code = ?, rp_payment_id = ?, rp_order_id = ? WHERE order_id = ?");
        
        // Bind parameters
        $stmt->bind_param("sssssssss", $status, $source, $step, $reason, $description, $code, $rp_payment_id, $rp_order_id, $order_id);
        
        // Execute query
        if ($stmt->execute()) {
            echo "Payment update success!\n payment_status=" . $status . "\nsource=" . $source . "\nstep=" . $step . "\nreason=" . $reason;

        } else {
            error_log("❌ Query Execution Error: " . $stmt->error);
            echo "Payment update failed!";
        }
        
        // Close statement
        $stmt->close();
    } catch (Exception $e) {
        error_log("❌ Database Error: " . $e->getMessage());
        echo "Database error occurred!";
    }
}
?>
