<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'db_connection.php';  // Ensure this file correctly initializes $conn

if(isset($_GET)){
    $order_id = isset($_GET['oid']) ? $_GET['oid'] : 'Missing OID';
    $rp_payment_id = isset($_GET['rp_payment_id']) ? $_GET['rp_payment_id'] : 'Missing Payment ID';
    $razorpay_order_id = isset($_GET['razorpay_order_id']) ? $_GET['razorpay_order_id'] : 'Missing Order ID';
    $rp_signature = isset($_GET['razorpay_order_id']) ? $_GET['rp_signature'] : 'Missing Signature';
    $status = 'success';
    
    // Pass $conn to the function
    update_order_payment_status($conn, $razorpay_order_id, $status, $rp_payment_id, $rp_signature);
}

function update_order_payment_status($conn, $razorpay_order_id, $status, $rp_payment_id, $rp_signature) {
    try {
        // Prepare statement
        $stmt = $conn->prepare("UPDATE orders SET payment_status = ?, razorpay_payment_id = ?, rp_signature = ? WHERE razorpay_order_id = ?");
        
        // Bind parameters
        $stmt->bind_param("ssds", $status, $rp_payment_id, $rp_signature, $razorpay_order_id);
        
        // Execute query
        if ($stmt->execute()) {
            error_log("Order Updated: Razor Pay Order ID: $razorpay_order_id | Status: $status | Payment ID: $rp_payment_id | rp_signature: ₹$rp_signature");
            echo "Order Updated: Razor Pay Order ID: $razorpay_order_id | Status: $status | Payment ID: $rp_payment_id | rp_signature: ₹$rp_signature";
            echo "Payment success!";
        } else {
            error_log("Query Execution Error: " . $stmt->error);
            echo "Payment update failed!";
        }
        
        // Close statement
        $stmt->close();
    } catch (Exception $e) {
        error_log("❌ Database Error: " . $e->getMessage());
        echo "Database error occurred!";
    }
}
?>
