<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'vendor/autoload.php';
// use Razorpay\Api\Api;
// echo"env ". $_ENV['APP_ENV'];die;
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, PUT, PATCH, DELETE');
header("Content-Type: application/json");
header("Accept: application/json");
header('Access-Control-Allow-Headers: Access-Control-Allow-Origin, Access-Control-Allow-Methods, Content-Type');

require 'db_connection.php'; // Include your database connection file

if (isset($_POST['action']) && $_POST['action'] === 'payOrder') {
    $razorpay_mode = $appEnv = $_ENV['APP_ENV'];

    if ($appEnv === 'production') {
        $razorpay_key = $razorpayKeyId = $_ENV['RAZORPAY_LIVE_KEY_ID'];
        $razorpayKeySecret = $_ENV['RAZORPAY_LIVE_KEY_SECRET'];
    } else {
        $razorpay_key = $razorpayKeyId = $_ENV['RAZORPAY_TEST_KEY_ID'];
        $razorpayKeySecret = $_ENV['RAZORPAY_TEST_KEY_SECRET'];
    }
    $authAPIkey = "Basic " . base64_encode($razorpay_key . ":" . $razorpayKeySecret);
    // echo $authAPIkey;die;

    // Generate unique order ID
    $order_id = uniqid();

    // Collect form data
    $billing_name = $_POST['billing_name'];
    $billing_mobile = $_POST['billing_mobile'];
    $billing_email = $_POST['billing_email'];
    // $shipping_name = $_POST['shipping_name'];
    // $shipping_mobile = $_POST['shipping_mobile'];
    // $shipping_email = $_POST['shipping_email'];
    $paymentOption = $_POST['paymentOption'];
    $payAmount = $_POST['payAmount'];

    $note = "Payment of amount Rs. " . $payAmount;

    $postdata = [
        "amount" => $payAmount * 100, // Convert to paise
        "currency" => "INR",
        "receipt" => $note,
        "notes" => [
            "notes_key_1" => $note,
            "notes_key_2" => ""
        ]
    ];

    // Create order in Razorpay
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://api.razorpay.com/v1/orders',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($postdata),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: ' . $authAPIkey
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);
    // echo"<pre>";print_r($response);die;
    $orderRes = json_decode($response);
    if (isset($orderRes->id)) {
        $rpay_order_id = $orderRes->id;
        $payment_status = 'Pending';
        // Insert order into database
        $sql = "INSERT INTO orders (order_id, razorpay_order_id, amount, name, email, phone, payment_status, orders_response, created_at) 
        VALUES ('$order_id', '$rpay_order_id', $payAmount, '$billing_name', '$billing_email', '$billing_mobile', '$payment_status','$response', NOW())";
        // echo $sql;die;
        // Execute query
        if ($conn->query($sql) === TRUE) {
            echo json_encode([
                'res' => 'success',
                'order_number' => $order_id,
                'userData' => [
                    'amount' => $payAmount,
                    'description' => "Pay bill of Rs. " . $payAmount,
                    'rpay_order_id' => $rpay_order_id,
                    'name' => $billing_name,
                    'email' => $billing_email,
                    'mobile' => $billing_mobile
                ],
                'razorpay_key' => $razorpay_key
            ]);
        } else {
            echo json_encode(['res' => 'error', 'info' => 'Database Error: Unable to insert order']);
        }
    } else {
        echo json_encode(['res' => 'error', 'info' => 'Error with payment']);
    }
} else {
    echo json_encode(['res' => 'error', 'info' => 'Invalid Request']);
}
?>
